/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.feature;

import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.IProjectile;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmLootTables;
import svenhjol.charm.world.client.render.RenderChargedEmerald;
import svenhjol.charm.world.entity.EntityChargedEmerald;
import svenhjol.charm.world.item.ItemChargedEmerald;
import svenhjol.meson.Feature;
import svenhjol.meson.helper.LootHelper;

public class ChargedEmeralds
extends Feature {
    public static ItemChargedEmerald emerald;

    @Override
    public String getDescription() {
        return "If you are holding an emerald and are struck by lightning, the emerald will become charged and you will take no damage.\nRight-click a Charged Emerald to throw it, creating a lightning strike at the point of impact.";
    }

    @Override
    public void configure() {
        super.configure();
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        emerald = new ItemChargedEmerald();
        String name = "charm:charged_emerald";
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(name), EntityChargedEmerald.class, (String)name, (int)1, (Object)Charm.instance, (int)64, (int)10, (boolean)true);
        BlockDispenser.field_149943_a.func_82595_a((Object)emerald, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return new EntityChargedEmerald(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityChargedEmerald.class, (IRenderFactory)RenderChargedEmerald.FACTORY);
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        int weight = 0;
        int quality = 0;
        LootFunction[] functions = new LootFunction[]{};
        LootCondition[] conditions = new LootCondition[]{};
        if (event.getName().equals((Object)LootTableList.field_186422_d)) {
            weight = 10;
        }
        if (event.getName().equals((Object)CharmLootTables.TREASURE_UNCOMMON)) {
            weight = 10;
        }
        if (weight > 0) {
            LootHelper.addToLootTable(event.getTable(), emerald, weight, quality, functions, conditions);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

